/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.forestmobs.entity;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupFire;
import com.lycanitesmobs.api.IGroupPlant;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.forestmobs.entity.EntityTrent;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EntityEnt
extends EntityCreatureTameable
implements IMob,
IGroupPlant {
    public EntityEnt(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 2;
        this.experience = 5;
        this.spawnsUnderground = false;
        this.hasAttackSound = true;
        this.spreadFire = true;
        this.canGrow = true;
        this.babySpawnChance = 0.1;
        this.setWidth = 0.8f;
        this.setHeight = 1.8f;
        this.setupMob();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee(this).setTargetClass(EntityPlayer.class).setLongMemory(false).setRate(40));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(4.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpClasses(EntityTrent.class));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupFire.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class).setCheckSight(false));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 15.0);
        baseAttributes.put("movementSpeed", 0.18);
        baseAttributes.put("knockbackResistance", 0.5);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 3.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Blocks.field_150364_r, 1, 0), 1.0f).setMaxAmount(6));
        this.drops.add(new DropRate(new ItemStack(Items.field_151055_y), 0.5f).setMaxAmount(6).setBurningDrop(new ItemStack(Items.field_151044_h)));
        this.drops.add(new DropRate(new ItemStack(Items.field_151014_N), 0.1f).setMaxAmount(3));
        this.drops.add(new DropRate(new ItemStack(Items.field_151080_bb), 0.05f).setMaxAmount(1));
        this.drops.add(new DropRate(new ItemStack(Items.field_151081_bc), 0.05f).setMaxAmount(1));
        this.drops.add(new DropRate(new ItemStack(Items.field_151034_e), 0.05f).setMaxAmount(1));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70090_H()) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 60, 2));
        } else if (this.field_70170_p.func_72896_J() && this.field_70170_p.func_175710_j(this.func_180425_c())) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 60, 1));
        }
    }

    @Override
    public boolean func_70686_a(Class targetClass) {
        if (targetClass.isAssignableFrom(EntityTrent.class)) {
            return false;
        }
        return super.func_70686_a(targetClass);
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        float leeching = this.getEffectStrength(this.getAttackDamage(damageScale));
        this.func_70691_i(leeching);
        return true;
    }

    @Override
    public float getDamageModifier(DamageSource damageSrc) {
        if (damageSrc.func_76347_k()) {
            return 4.0f;
        }
        if (damageSrc.func_76346_g() != null) {
            EntityLiving entityLiving;
            Item heldItem = null;
            if (damageSrc.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)damageSrc.func_76346_g();
                if (entityPlayer.func_184586_b(EnumHand.MAIN_HAND) != null) {
                    heldItem = entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
                }
            } else if (damageSrc.func_76346_g() instanceof EntityLiving && (entityLiving = (EntityLiving)damageSrc.func_76346_g()).func_184586_b(EnumHand.MAIN_HAND) != null) {
                heldItem = entityLiving.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
            }
            if (ObjectLists.isAxe(heldItem)) {
                return 4.0f;
            }
        }
        return super.getDamageModifier(damageSrc);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76421_d) {
            return false;
        }
        if (ObjectManager.getPotionEffect("paralysis") != null && potionEffect.func_188419_a() == ObjectManager.getPotionEffect("paralysis")) {
            return false;
        }
        super.func_70687_e(potionEffect);
        return true;
    }

    @Override
    public float getFallResistance() {
        return 100.0f;
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable baby) {
        return new EntityEnt(this.field_70170_p);
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }

    @Override
    public ResourceLocation getTexture() {
        if (!"Salty Tree".equals(this.func_95999_t())) {
            return super.getTexture();
        }
        String textureName = this.getTextureName() + "_saltytree";
        if (AssetManager.getTexture(textureName) == null) {
            AssetManager.addTexture(textureName, this.group, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return AssetManager.getTexture(textureName);
    }
}

